/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat;

import java.util.function.Supplier;
import net.creeperhost.minetogether.lib.chat.ChatAuth;
import net.creeperhost.minetogether.lib.chat.MutedUserList;
import net.creeperhost.minetogether.lib.chat.irc.IrcClient;
import net.creeperhost.minetogether.lib.chat.irc.pircbotx.PircBotClient;
import net.creeperhost.minetogether.lib.chat.profile.ProfileManager;
import net.creeperhost.minetogether.lib.web.ApiClient;
import org.jetbrains.annotations.VisibleForTesting;

public class ChatState {
    public final ApiClient api;
    public final ChatAuth auth;
    public final MutedUserList mutedUserList;
    public final ProfileManager profileManager;
    public final IrcClient ircClient;
    public boolean logChatToConsole;

    @VisibleForTesting
    protected ChatState(ApiClient api, ChatAuth auth, MutedUserList mutedUserList, ProfileManager profileManager, IrcClient ircClient, boolean logChatToConsole) {
        this.api = api;
        this.auth = auth;
        this.mutedUserList = mutedUserList;
        this.profileManager = profileManager;
        this.ircClient = ircClient;
        this.logChatToConsole = logChatToConsole;
    }

    public ChatState(ApiClient api, ChatAuth auth, MutedUserList mutedUserList, Supplier<String> realName, boolean logChatToConsole) {
        this.api = api;
        this.auth = auth;
        this.mutedUserList = mutedUserList;
        this.profileManager = new ProfileManager(auth.getHash()){

            @Override
            public ChatState getChatState() {
                return ChatState.this;
            }
        };
        this.profileManager.getOwnProfile().setPack(realName);
        this.ircClient = new PircBotClient(this, realName);
        this.logChatToConsole = logChatToConsole;
        for (String mutedUser : mutedUserList.getMutedUsers()) {
            this.profileManager.lookupProfileStale(mutedUser);
        }
    }
}

